/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.bearing;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.contraptions.bearing.BearingContraption;
import com.zurrtum.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class WindmillBearingBlockEntity
extends MechanicalBearingBlockEntity {
    protected ServerScrollOptionBehaviour<RotationDirection> movementDirection;
    protected float lastGeneratedSpeed;
    protected boolean queuedReassembly;

    public WindmillBearingBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.WINDMILL_BEARING, pos, state);
    }

    @Override
    public void updateGeneratedRotation() {
        super.updateGeneratedRotation();
        this.lastGeneratedSpeed = this.getGeneratedSpeed();
        this.queuedReassembly = false;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        boolean cancelAssembly = this.assembleNextTick;
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = cancelAssembly;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (!this.queuedReassembly) {
            return;
        }
        this.queuedReassembly = false;
        if (!this.running) {
            this.assembleNextTick = true;
        }
    }

    public void disassembleForMovement() {
        if (!this.running) {
            return;
        }
        this.disassemble();
        this.queuedReassembly = true;
    }

    @Override
    public float getGeneratedSpeed() {
        if (!this.running) {
            return 0.0f;
        }
        if (this.movedContraption == null) {
            return this.lastGeneratedSpeed;
        }
        int sails = ((BearingContraption)this.movedContraption.getContraption()).getSailBlocks() / (Integer)AllConfigs.server().kinetics.windmillSailsPerRPM.get();
        return (float)class_3532.method_15340((int)sails, (int)1, (int)16) * this.getAngleSpeedDirection();
    }

    @Override
    public boolean isWindmill() {
        return true;
    }

    protected float getAngleSpeedDirection() {
        RotationDirection rotationDirection = RotationDirection.values()[this.movementDirection.getValue()];
        return rotationDirection == RotationDirection.CLOCKWISE ? 1 : -1;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71464("LastGenerated", this.lastGeneratedSpeed);
        view.method_71472("QueueAssembly", this.queuedReassembly);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        if (!this.wasMoved) {
            this.lastGeneratedSpeed = view.method_71423("LastGenerated", 0.0f);
        }
        this.queuedReassembly = view.method_71433("QueueAssembly", false);
        super.read(view, clientPacket);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.movementDirection = new ServerScrollOptionBehaviour<RotationDirection>(RotationDirection.class, this);
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add(this.movementDirection);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.WINDMILL, AllAdvancements.WINDMILL_MAXED);
    }

    private void onDirectionChanged() {
        if (!this.running) {
            return;
        }
        if (!this.field_11863.method_8608()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public boolean isWoodenTop() {
        return true;
    }

    public static enum RotationDirection {
        CLOCKWISE,
        COUNTER_CLOCKWISE;

    }
}

